/*------------------------------------------------------------------------------*
 * File Name: nlsf_utils.h	 													*
 * Creation: Frank/P.J 2005-12-06												*
 * Purpose: OriginC Source H file												*
 * Copyright (c) OriginLab Corp. 2005, 2006, 2007, 2008, 2009, 2010				*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Leo 2005-12-9 MOVED_FROM_PFM_UTILS											* 
 *	Jasmine 02/06/06 GET_PARAMETERS_SETTINGS									*
 *	jasmine 02/11/06 MOVE_TO_NLSF_UTILS											*
 *	Jasmine 05/10/06 ENABLE_DISABLE_BOUNDS_SETTING								*
 *  Joe 8/17/06 MOVE_NLSF_FUNC_FROM_NLFITSESSION								*	
 *	ML 8/28/2006 MULTIPLE_DEPS_INDEPS_NLFIT										*
 *	Joseph 12/18/06 CHECK_NLF_SPEED												*
 *	Jasmine 01/27/07 SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH					*
 *	Cloud 03/23/07 INIT_PARAMS_FOR_PEAK_FUNC                                    *
 *  Cloud 03/24/07 MOVE_TO_DATA_H                                               *
 *	Arvin/Cheney 03/26/07 QA70-9527 SUPPORT_SETTING_PARAMS_FROM_OC_LT 			*
 *	Jasmine 04/02/07 SUPPORT_SIGN_DIGITS										*
 *	Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH						*
 *	Cheney 2007-4-14 IF_NO_THEME_AUTO_INIT_WILL_ACCORDING_TO_FDF				*
 *	Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS				*
 *	Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD										*
 *	Cheney 2007-5-5 FUNC_DESCRIPTION_NOT_WORK									*
 *	Cheney 2007-5-25 DO_SAVE_FDF												*
 *	Cheney 2007-6-6 SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT							*
 *	Cheney 2007-6-7 SHOULD_USE_FDFT_CONVERT_BOOL_TO_01_WHEN_NODE_VAL_IS_STRING	*
 *	Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC		*
 *	Jasmine 06/08/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION					*
 *	Arvin 07/10/07 v8.0656 CLEAN_CODE_FOR_XF_SIMCURVE_AND_SIMSURFACE			*
 *	Folger 07/11/07 ADD_LOAD_FUNCTION_NAME_FROM_CUSTOMIZE_XML					*
 *	Cheney 2007-8-21 QA70-10256-P7 ADD_GLOBAL_FUC_FOR_UPDATE_CONTOUR_LEVEL		*
 *	Cloud 08/21/2007 SURFACE_INIT												*
 *	Folger 02/12/08 IMPROVE_SIMULATE_CURVE										*
 *	Arvin 03/03/08 QA-11206 SETUP_CONTOUR_PLOT_FOR_SURFACE_FIT					*
 *	Folger 03/20/08 QA80-11155 CENTRALIZE_OUTPUT_PARAMETER_COMMENTS_FOR_SIMCURVE_AND_SIMSURFACE
 *	Folger 04/02/08 QA80-11364 IMRPOVE_PA_FIT_BY_STORE_FIT_FUNCTION_TREE_FOR_LOOP
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Folger 04/11/08 APPLY_FDF_ORIGINAL_SETTING_AFTER_APPLY_THEME				*
 *	Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ						*
 *	Jasmine 04/14/08 SIM_ASK_CONVERT_PA_FIT_TREE_DATA_ID						*
 *	Jasmine 04/22/08 CENTRAILIZE_GET_NLSF_GET_PARAM_NAMES_CODES					*
 *	Hong 07/25/08 QA80-11593 FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
 *	Folger 07/29/08 QA80-11909 PA_FIT_SHOULD_PICK_UP_DEFAULT_PARAMETER_VALUES_IN_FDF_AND_CENTER_VALUES_FROM_FIND_PEAK
 *	Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
 *	Kyle 11/05/2008 QA80-12509-P1 ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO	*
 *	Sophy 11/10/2008 CENTRALIZE_CODE_PEAK_LABEL_TYPE_FROM_NLFPREVIEW_AND_PAWIZCORE
 *	Kyle 11/11/2008 QA80-12564 CREATE_X_Y_DATA_BASE_ON_GRAPY_SCALE				*
 *	Hong 12/30/08 QA80-12878 v8.0992 FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION
 *	Jasmine 04/16/09 QA80-13424 REWRITE_FUNCTION_TO_GET_PREVIEW_NAME			*
 *	Sophy 6/5/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION					*
 *	Folger 06/18/09 CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES		*
 *	Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS					*
 *	Kyle 11/04/2009 QA80-14584 SCV_ADD_FITTING_FUNCTIONS						*
 *	Kenny 11/11/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES		*
 *	Folger 12/14/09 QA81-14832 QUICK_NLSF_FITTING								*
 *  Iris 1/25/2010 PARETO_CHAR_ADD_LABEL_PLOT									*
 *	Folger 06/24/10 ORG-390-S1 USE_ONE_IF_NO_PARAM_INIT_VALUE_SPECIFIED			*
 *------------------------------------------------------------------------------*/

#ifndef _NLSF_UTILS_H
#define _NLSF_UTILS_H

/// ML 8/28/2006 MULTIPLE_DEPS_INDEPS_NLFIT
#define		__NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
/// end MULTIPLE_DEPS_INDEPS_NLFIT

///Cheney 2007-6-6 SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT
#define		ALLOW_LINEAR_CONSTRAINT_WHEN_FITTING
///end SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT

#define		MAX_NUM_INDEP		4 	/////Iris 9/21/06 MULTI_INDEP_PLOTS_NEED_OUT_MATRIX_GRAPH, in ONLSF Evaluate method only support 4 indeppendents as input

///Joseph 12/18/06 CHECK_NLF_SPEED
///// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
//#define		MAX_NUM_TOTAL_PARAMS		99
/////end ADD_PARAMETER_SETTING_TO_THEME	
#define		MAX_NUM_TOTAL_PARAMS		20
///End CHECK_NLF_SPEED

#define		STR_PARAM_INIT_RESULT			"IfParamInitDone" ///Iris 07/03/2007 v8.0654 SHOW_PARAMINITSECCEED_NODE_IN_SETTINGS_TAB_LEFT_SIDE

///Joe 8/17/06 MOVE_NLSF_FUNC_FROM_NLFITSESSION
#define STR_FUNC_GENERAL_INFO				"General Information"
#define STR_FUNC_FIT_PARAM					"Fitting Parameters"
#define STR_FUNC_FORMULA					"Formula"
/// Hong 11/06/07 v8.0741 MORE_LOCALIZATION
// remove as NOT used and redefined(NumFunctionOrganizer.h)
//#define STR_FUNC_CONSTRAINTS				"Constraints"
/// end MORE_LOCALIZATION
#define STR_FUNC_SCRIPT						"Script"
#define STR_PARAM_SETTING                   "ParameterSetting"
///Sophy 6/19/2008 QA80-10686 TREATE_DIFFERENT_WEIGHT_AS_DIFFERENT_INPUTDATA_ON_COMPARE_FIT_RESULT
//moved from NLFitSession.h
#define STR_LIST_WEIGHTING_METHODS 	_L("No Weighting|Instrumental|Statistical|Arbitrary Dataset|Direct Weighting|Variance ~ y^2|Variance = a*y^b|Variance = c^b+a*y^b|Variance = a*y^b*c^(tlast-t)|Variance ~ yfit|Variance ~ yfit^2|Variance = a*yfit^b|Variance = c^b+a*yfit^b|Variance = a*yfit^b*c^(tlast-t)")
///end TREATE_DIFFERENT_WEIGHT_AS_DIFFERENT_INPUTDATA_ON_COMPARE_FIT_RESULT

///------ Folger 06/24/10 ORG-390-S1 USE_ONE_IF_NO_PARAM_INIT_VALUE_SPECIFIED
#define		NANUM		(-1.23456789E-300)
///------ End USE_ONE_IF_NO_PARAM_INIT_VALUE_SPECIFIED

///End MOVE_NLSF_FUNC_FROM_NLFITSESSION
/// end SETTING_NLSFTREE_ORIGINC_COMPILE
//currently, we don't use system folder inifile
///---end NLF_CLEAN_VISIT_INIFILE
///End FUNCTION_OPERATOR_INI_AND_FDF

//Commetnts last updated by Iris on 3/04/05
/**
		set the keys and values for sepcial section in NLSF.ini file
	Paramaters:
		lpcszSection = [input]section name of nlsf.ini want to read.
		saKeys =[input]key names
		saValues =[input] key values.
		pnDefaultSel =[input]default function of nlsf.ini function cateogry.
		nIniPath =[input] folder flag, you can use USER_FOLDER, ALL_USER_FOLDER, SYS_FOLDER.
	Example1:
		void nlf_set_section_keys_and_values_ex1()
		{
			int nSel = 0;
			vector<string> vsKeys = {"My Function"};
			vector<string> vsVals = {"Test"};
			nlf_set_section_keys_and_values("Origin Basic Functions", vsKeys, vsVals, &nSel);
		}
	Return:
		Return true if successfully.
*/
bool nlf_set_section_keys_and_values(LPCSTR lpcszSection, const vector<string> &saKeys, const vector<string> &saValues ,int* pnDefaultSel = NULL, int nIniPath = ORIGIN_PATH_USER);

///Arvin 11/14/07 JUST_MOVE_FUNCTION_FROM_NUMFUNCTIONORGANIZER_TO_NLSF_UTILS
/**
		get the keys and values from sepcial section name from NLSF.ini file.
	Paramaters:
		lpcszSection = [input]section name of nlsf.ini want to read.
		saKeys =[output]Section keys.
		saValues =[output]Section keys value.
		pnDefaultSel =[output]default function of nlsf.ini function cateogry.
		nIniPath =[input] folder flag, you can use USER_FOLDER, ALL_USER_FOLDER, SYS_FOLDER.
	Example1:
		void nlf_get_section_keys_and_values_ex1()
		{	
			vector<string> vsFunction, vsFile;
			bool bRet = nlf_get_section_keys_and_values( "Waveform",vsFunction, vsFile );
		}
	Return:
		Return true if get it.
*/
/// Kenny 11/11/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES, centralize code in FilePublish.h and NumFunctionOrganizer.h
//bool nlf_get_section_keys_and_values(LPCSTR lpcszSection, vector<string> &saKeys, vector<string> &saValues =NULL ,int* pnDefaultSel =NULL, int nIniPath = ORIGIN_PATH_USER);//=NULL = NULL, 
bool nlf_get_section_keys_and_values(LPCSTR lpcszSection, 
									 vector<string> &saKeys, 
									 vector<string> &saValues = NULL, 
									 int* pnDefaultSel = NULL, 
									 int nIniPath = ORIGIN_PATH_USER, 
									 LPCSTR lpcszIniPath = NULL);
/// End QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
///END JUST_MOVE_FUNCTION_FROM_NUMFUNCTIONORGANIZER_TO_NLSF_UTILS

///Jasmine 02/17/09 QA80-10378 SHARE_FUNCTION_ORGANIZER_CODE_WITH_SELECTCAT
/*$
		get all NLSF categories
*/
/// Kenny 11/11/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
//int nlsf_get_category_list(vector<string>& vsCategorys);
int nlsf_get_category_list(vector<string>& vsCategorys, vector<int>& vnSeparatorIndices = NULL);

/// Kenny: I found that these two similar procedures are used in FilePublish.h and NumFunctionOrganizer.h
/// and just with slight difference, so I try to centralize them and move to here
bool nlsf_update_function(LPCSTR lpcszCategoryName, 
						  LPCSTR lpcszNewName, 
						  LPCSTR lpcszOldName, 
						  LPCSTR lpcszFileName, 
						  int nIniPath = ORIGIN_PATH_USER, 
						  LPCSTR lpcszIniPath = NULL);

bool nlsf_update_category(LPCSTR lpcszNewName, 
						  LPCSTR lpcszOldName, 
						  int nIniPath = ORIGIN_PATH_USER, 
						  LPCSTR lpcszIniPath = NULL);
/// End QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
///End SHARE_FUNCTION_ORGANIZER_CODE_WITH_SELECTCAT

bool nlf_init_math_equ_fonts();		///Frank 11/25/05 move from fofunctprv.h

//----- CPY 10/5/04 FUNC_PREV_FORMULA_IN_TREE
///Jasmine 04/16/09 QA80-13424 REWRITE_FUNCTION_TO_GET_PREVIEW_NAME
/*#
	get the function name, full path file name and group name. 
	Paramaters:
		trFunction = [input] Function tree from fdf file.
		strFuncName =[output] Function name of function tree.
		pstrFullpathFileName =[output] Function full path file name.
		pGroupName =[output] Function group name from fdf file filed Function Source.
	Return:
		if get function name succese will return true, else return false.
*/
bool nlf_get_func_preview_names(const TreeNode &trFunction, string& strFuncName, string& strFullpathFileName, string* pGroupName = NULL);
///End REWRITE_FUNCTION_TO_GET_PREVIEW_NAME

//Commetnts last updated by Frank on 1/11/05
/**
		find the correct range column range, row range, worksheet , range name out.
	Paramaters:
		trFunction = [input] Function tree from fdf file.
		strFuncName =[output] Function name of function tree.
		strFDFname =[output] Function from file name.
		pstrFullpathFileName =[output] Function full path file name.
		pGroupName =[output] Function group name from fdf file filed Function Source.
	Example1:
		#include <..\originlab\functiongroup.h>
		void nlf_get_func_names_ex1()
		{	
			Tree	tr;
			TreeNode trFunction = tr.AddNode("sine");
			NLFunctionList NFOList;
			string strFunctionName = "sine";
			string strCategoryName = "Waveform";
			NFOList.GetFunctionDetail(trFunction,strFunctionName, strCategoryName);
			string strFuncName, strFDFname;
			bool bRet = nlf_get_func_names( trFunction, strFuncName, strFDFname);
		}
	Return:
		if get function name succese will return true, else return false.
*/
bool nlf_get_func_names(const TreeNode &trFunction, string &strFuncName, string& strFDFname, string* pstrFullpathFileName = NULL, string* pGroupName = NULL);
//Commetnts last updated by Frank on 1/11/05
/**
		find the correct range column range, row range, worksheet , range name out.
	Paramaters:
		trPicts = [input] TreeNode storage picture info.
		strFuncName =[input] Function name of function tree.
		strFDFname =[input] Function from file name.
		bFormula = [input]If ture will get formula info, else get sample curve info.
	Example1:
		#include <..\originlab\functiongroup.h>
		void nlf_get_preview_image_ex1()
		{	
			Tree	tr;
			TreeNode trFunction = tr.AddNode("sine");
			NLFunctionList NFOList;
			string strFunctionName = "sine";
			string strCategoryName = "Waveform";
			NFOList.GetFunctionDetail(trFunction,strFunctionName, strCategoryName);
			string strFuncName, strFDFname;
			bool bRet = nlf_get_func_names( trFunction, strFuncName, strFDFname);
			bRet = nlf_get_preview_image( trFunction, strFuncName, strFDFname);
		}
	Return:
		if get succese will return true, else return false.
*/
bool nlf_get_preview_image(TreeNode &trPicts, const string& strFDFname, const string &strFuncName, bool bFormula = true);

#define IDE_SIMULATE_PARA_BEGIN 1000
#define STR_SIMULATION_FILE		"fdf_simulate.ois"
///Arvin 07/10/07 v8.0656 CLEAN_CODE_FOR_XF_SIMCURVE_AND_SIMSURFACE-
//#define USER_SIMUALTE_FILE		okutil_get_origin_path(ORIGIN_PATH_USER, THEME_SUB_FOLDER)+STR_SIMULATION_FILE
#define USER_SIMULATE_FILE		okutil_get_origin_path(ORIGIN_PATH_USER, THEME_SUB_FOLDER)+STR_SIMULATION_FILE
///end CLEAN_CODE_FOR_XF_SIMCURVE_AND_SIMSURFACE
#define SYS_SIMULATE_FILE		okutil_get_origin_path(ORIGIN_PATH_SYSTEM, THEME_SUB_FOLDER)+STR_SIMULATION_FILE
#define THEME_TEMP_FILE			okutil_get_origin_path(ORIGIN_PATH_USER, "OCTemp")+"Tempfdf_simulate.ois";
/**
load nlf setting from fdf_simulate.ois under theme folder by function name.
Parameters:
	lpcszFuncName = [input] function name, get this function settings..
	vParamVals = [output] parameter values
	ptrSettings = [output] all nlf simulate settings. pair with NodeID and  value.
*/
bool nlf_load_simulate_settings(LPCSTR lpcszFuncName,vector& vParamVals, TreeNode* ptrSettings);
/**
	load nlf setting from fdf_simulate.ois under theme folder by function name.
Parameters:
	lpcszFuncName = [input] function name, get this function settings..
	ptrSettings = [output] function's nlf simulate settings. pair with NodeID and  value.
*/
bool nlf_load_simulate_settings(LPCSTR lpcszFuncName,TreeNode* ptrSettings);
/**
	save nlf setting to fdf_simulate.ois under theme folder by function name.
Parameters:
	lpcszFuncName = [input] function name, set this function settings..
	ptrSettings = [input] function's nlf simulate settings. pair with NodeID and  value.
*/
bool nlf_save_simulate_settings(LPCSTR lpcszFuncName, const TreeNode& trSettings);
/**
	Create theme tree from GUI tree, can use to get the GetN box dialog and others theme relate dialog's theme tree.
*/
void create_theme_from_tree(TreeNode &trGUI, TreeNode &trThemeNode);

///Leo 2005-12-9 MOVED_FROM_PFM_UTILS
/**
	Remarks: initializing a nlf given by FDF name. depend on vector vx and vy, 
	          achieve the initial Parameters set. 
	         
	Keywords:
	Example1:
		bool nlsf_init_ex1(vector& vX, vector& vY, vector<string>& vParamNames, vector& vParams)
		{
			vector iniParams;
			string strFuncFDFName = "ExpDec1";
			vector iniParams;
			if (!nlsf_init(strFuncFDFName, vX, vY, vParamNames, iniParams))
			{
				return false;
			}
			vector<bool> vbFixed;
			if (!nlsf_fit(strFuncFDFName, vX, vY, vParams, vbFixed))
			{
				vParams = iniParams;
			}
			return true;
		
		}
	Parameters:
		strFuncFDFName 	= [input]   nlf file name
		vX  			= [modify]  x data of the fitting curve, will use in initial fitting
		vY  			= [modify]  y data of the fitting curve, will use in initial fitting
		vstrParam  		= [output]  string vector of Parameters names. tie to vParams' order
		vParams    		= [output]  initial value of Parameters.
	Return:
		if initial fit succese will return true, else return false.
	SeeAlso:
 */ 
bool nlsf_init(string strFuncFDFName, vector& vX, vector& vY, vector<string>& vstrParam, vector& vParams);
/// Cloud 08/21/2007 SURFACE_INIT
bool nlsf_init(string strFunc, vector& vz, vector& vx, vector& vy, vector<string>& vstrParams, vector& vParams);
bool nlsf_init(string strFunc, double dxmin, double dxmax, double dymin, double dymax, const matrix& mz, vector<string>& vstrParams, vector& vParams);

//------ Folger 04/02/08 QA80-11364 IMRPOVE_PA_FIT_BY_STORE_FIT_FUNCTION_TREE_FOR_LOOP
bool nlsf_init(TreeNode &trFF, vector& vX, vector& vY, vector<string>& vstrParams, vector& vParams);
//------

/// End SURFACE_INIT

/**
	Remarks:
	Keywords:
	Example1:
		void nlsf_fit_ex1
		{
		
		}
	Parameters:
	Return:
	SeeAlso:
 */ 
bool nlsf_fit(string strFuncName, vector& vX, vector& vY, vector& vParams, vector<bool>& vbFixed, RegStats* psRegStats = NULL, int nReplicas = 0);

/**
	Remarks:
	Keywords:
	Example1:
		void nlsf_evaluate_ex1
		{
		
		}
	Parameters:
	Return:
	SeeAlso:
 */
///Arvin 1/04/06 FIND_Z_FROM_XY
//bool nlsf_evaluate(string strFuncName,string strCategory, vector& vX, vector& vY, vector& vParams);
//bool nlsf_evaluate(string strFuncName,string strCategory, vector& vX, vector& vY, vector& vParams, vector& vZ = NULL);
bool nlsf_evaluate(LPCSTR lpcszFunction, LPCSTR lpcszCategory, vector& vX, vector& vY, vector& vParams, vector& vZ = NULL);
///end FIND_Z_FROM_XY

///Cheney 2007-4-24 CLEAN_UP_FDF_TREE_LOAD
bool nlsf_evaluate(TreeNode& trFF, vector& vX, vector& vY, vector& vParams, vector& vZ = NULL);
///end CLEAN_UP_FDF_TREE_LOAD

/**
	Remarks: get a nlf FDF name and function name from file list 
	Keywords:
	Example1:
		void nlsf_get_func_ex1(vector& vX, vector& vY, int nSelFuncIndex)
		{
			vector vParam;
			vector <string> vstrParamNames;
			string strFunc;
			string strFile;
			nlsf_get_func(nSelFuncIndex, strFunc, strFile, "Baseline");
			
			if (!nlsf_get_fit_para(strFile, vx, vy, vstrParamNames, vParam))
			{
				return false;
			}			
		}
	Parameters:
		funcIndex = [input] Index of function in Category. 
		strfuncName = [output] function name
		strfileName = [output] short name of file that includes function 
		strCategory = [input]  Category name
	Return:
		if get succese will return true, else return false.
	SeeAlso:
 */ 
//Sandy 12/06/05 ADD_FUNC_NAME_OUTPUT
//bool nlsf_get_func_filename(int funcIndex, string& strfuncNames)
bool nlsf_get_func(int funcIndex, string& strfuncName, string& strfileName, string strCategory);


///Sandy 2007-7-12 add
/**
	Remarks: find nlf FDF name by function name from file list 
	Keywords:
	Example1:

	Parameters:

		strCategory = [input]  Category name
		strfuncName = [input] function name
		strfileName = [output] short name of file that includes function 
		bFullPath   = [input] get full path of fdf file or not
	Return:
		if get succese will return true, else return false.
	SeeAlso:
 */ 
bool nlsf_func_to_fdf(const string strCategory, const string strfuncName, string& strfileName,  bool bFullPath = false);
//end

/**
	Remarks:load a functions list from certain Category  
	Keywords:
	Example1:
		void nslf_get_func_list_ex1(TreeNode& trNode)
		{
			string strFuncList;
			vector<string> vsFunc;
			vector<string> vsFuncFileNames;

			if(nslf_get_func_list(vsFunc, vsFuncFileNames, "Baseline"))
			{
				strFuncList.SetTokens(vsFunc, '|');		
				trNode.SetAttribute(STR_COMBO_ATTRIB, strFuncList);
			}		
		}
	Parameters:
		vsFuncNames = [output] vector of functions' name
		vsFileNames = [output] vector of files that includes function 
		strCategory = [input]  Category name
	Return:
		if get succese will return true, else return false.
	SeeAlso:
 */ 


bool nslf_get_func_list(vector<string>& vsFuncNames, vector<string>& vsFileNames, string strCategory);
///End MOVED_FROM_PFM_UTILS

//2006-3-10 Sandy MOVE_FROM_XF
/**
	Remarks:load a function's Parameters Name to a string vector  
	Keywords:
	Example1:

	Parameters:
		lpszFunction = [input] function name
		lpcszCategory = [input]  category of function
		vParamNames = [output] parameter names of this function
	Return:
		if get succese will return number of parameters, else return 0.
	SeeAlso:
*/
/// Iris 12/24/2008 v8.0990c CLEANUP_NLSF_GET_PARAM_NAMES_CODES 
//bool nlsf_get_param_names(string strFuncName, vector<string>& vParamNames, string strCategory);
int nlsf_get_param_names(LPCSTR lpszFunction, LPCSTR lpcszCategory, vector<string>& vParamNames);
///end CLEANUP_NLSF_GET_PARAM_NAMES_CODES

/**$
	Parameters:
		lpszFunction = [input] function name
		lpcszCategory = [input]  category of function
	Return:
		if get succese will return number of parameters, else return 0.

*/
int nlsf_get_number_of_params(LPCSTR lpszFunction, LPCSTR lpcszCategory);

///Arvin 10/25/06 NLSF_GET_DEPENDENT_VARIABLE_NUMBER
/**
		Get dependent variables number of FDF function
	Parameters:
		trFunc = [input] FDF function tree
	Return:
		the number of dependent variable for numeric function
*/
///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
//int 	nlf_get_dependent_variable_number(const TreeNode& trFunc);
int 	nlf_get_dependent_variables(const TreeNode& trFunc, vector<string>* pvsDepVarNames = NULL);
///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH

/**
		Get dependent variables number of FDF function
	Parameters:
		lpcszFuncName = [input] FDF function name
	Return:
		the number of dependent variable for numeric function
*/
///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
//int 	nlf_get_dependent_variable_number(LPCSTR lpcszFuncName);
int 	nlf_get_dependent_variables(LPCSTR lpcszFuncName, vector<string>* pvsDepVarNames = NULL);
///end NLSF_GET_DEPENDENT_VARIABLE_NUMBER

///Iris 12/12/05 MOVE_NLF_TO_UTILS_FILE

/**
		Get variables number of FDF function
	Parameters:
		lpcszFuncName = [input] FDF function name
	Return:
		the number of variable for numeric function
*/
///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
//int 	nlf_get_independent_variable_number(LPCSTR lpcszFuncName);
int 	nlf_get_independent_variables(LPCSTR lpcszFuncName, vector<string>* pvsIndepVarNames = NULL);
///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
 
/**
		Get variables number of FDF function
	Parameters:
		trFunc = [input] FDF function tree
	Return:
		the number of variable for numeric function
*/
///Cheney 2007-4-9 CORRECT_LOGIC_OF_CALLING_INIT_BRANCH
//int 	nlf_get_independent_variable_number(const TreeNode& trFunc);
int 	nlf_get_independent_variables(const TreeNode& trFunc, vector<string>* pvsIndepVarNames = NULL);
///end CORRECT_LOGIC_OF_CALLING_INIT_BRANCH

int		nlf_get_duplicate_number(const TreeNode& trFunc);
int		nlf_get_duplicate_offset(const TreeNode& trFunc);
int		nlf_get_duplicate_unit(const TreeNode& trFunc);

bool 	nlf_is_3d_function(TreeNode& trOperation);
///End MOVE_NLF_TO_UTILS_FILE

//void init_nlsf_functs_lists(TreeNode &trGetN, vector<string> &vsShowCategory);
void update_nlsf_functs_lists(TreeNode &trGetN);
bool get_fdf(TreeNode &trGetN, TreeNode &trFF);
///Kyle 11/11/2008 QA80-12564 CREATE_X_Y_DATA_BASE_ON_GRAPY_SCALE
//void createXYData(Tree trFF, vector& vX, vector& vY, vector& vParams, double dXMin, double dXMax, int nPts);
void createXYData(Tree trFF, vector& vX, vector& vY, vector& vParams, double dXMin, double dXMax, int nPts, int nXScale = LINEAR_SPACE);
///End CREATE_X_Y_DATA_BASE_ON_GRAPY_SCALE

///Jasmine 02/06/06 GET_PARAMETERS_SETTINGS
///Jasmine 02/14/06 ADD_SET_SIZE
int nlf_set_param_names_vector(LPCSTR lpcszParaName, vector<string>& vsParamNames);
int	nlf_set_param_meaning_vector(LPCSTR lpcszParaMeaning, vector<string>& vsParamMeanings, int nOldSize, bool bResize = false);
int	nlf_set_param_significant_digits_vector(LPCSTR lpcszParaSignDigits, vector<int>& vsParamSignDigits, int nOldSize, bool bResize = false);///Jasmine 04/02/07 SUPPORT_SIGN_DIGITS
int nlf_set_param_fixed_vector(LPCSTR lpcszParaValue, vector<bool>& vbParamFixed, int nOldSize, bool bResize = false);
///------ Folger 06/24/10 ORG-390-S1 USE_ONE_IF_NO_PARAM_INIT_VALUE_SPECIFIED
//int nlf_set_param_values_vector(LPCSTR lpcszParaValue, vector& vdParamValues, int nOldSize, bool bResize = false);
int nlf_set_param_values_vector(LPCSTR lpcszParaValue, vector& vdParamValues, int nOldSize, bool bResize = false, double rValueOverNANUM = NANUM);
///------ End USE_ONE_IF_NO_PARAM_INIT_VALUE_SPECIFIED
int	nlf_set_param_bounds_vector(LPCSTR lpcszParaBound, vector& vdParamBounds, int nOldSize, bool bResize = false);
int nlf_set_param_exclusive_vector(LPCSTR lpcszParaBound, vector<bool>& vbParamExclusive, int nOldSize, bool bResize = false);
int nlf_set_param_on_bounds_vector(LPCSTR lpcszParaBound, vector<bool>& vbParamOnBounds, int nOldSize, bool bResize = false);///Jasmine 05/10/06 ENABLE_DISABLE_BOUNDS_SETTING
///End ADD_SET_SIZE
string nlf_get_param_names_list(const vector<string> vsParamNames);
///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
string nlf_get_param_unit_list(const vector<string> vsParamUnits);
int	nlf_set_param_unit_vector(LPCSTR lpcszParaUnit, vector<string>& vsParamUnits, int nOldSize, bool bResize = false);
///End ADD_UNIT_FOR_PARAMETER_SETTINGS
string nlf_get_param_meaning_list(const vector<string> vsParamMeanings);
string nlf_get_param_significant_digits_list(const vector<int> vnSignDigites);	///Jasmine 04/02/07 SUPPORT_SIGN_DIGITS
///jasmine 02/11/06 MOVE_TO_NLSF_UTILS
string nlf_get_param_value_list(const vector vdParamValues, const vector<bool> vbParamFixed);
string nlf_get_param_bound_list(const vector vdParamBounds, const vector<bool> vbParamExclusive, const vector<bool> vbParamOnOff);
///End MOVE_TO_NLSF_UTILS
string nlf_get_sel_combo_list(LPCSTR lpcszComboList, int index = 0, char cFirstSep = '|', char cSecondSep = ';', LPCSTR lpcszDefault = NULL);
int nlf_get_combo_list_index(LPCSTR lpcszComboList, LPCSTR lpcszItem, char cFirstSep = '|', char cSecondSep = ';');
///End GET_PARAMETERS_SETTINGS

/// Iris 4/13/06 MOVE_NLSF_FUNC_FROM_NLFITSESSION
///Joe 8/17/06 MOVE_NLSF_FUNC_FROM_NLFITSESSION
//bool 	nlsf_get_FDF_tree_from_func_name(TreeNode &trFDF, LPCSTR lpcszFuncName);
///Cheney 2007-6-7 SHOULD_USE_FDFT_CONVERT_BOOL_TO_01_WHEN_NODE_VAL_IS_STRING
//bool nlsf_get_FDF_tree_from_func_name(TreeNode &trFDF, LPCSTR lpcszFuncName, string& strCategory = NULL);
//refer to FDFTree.h
//enum{
	//FDFT_INIT_FULL_ENTRIES  = 0x0001,	// will first init full tree before reading and will use copy-tree-by-id to fill the complete tree									//see nlsf_create_FDF_tree
	//FDFT_CONVERT_BOOL_TO_01  = 0x0002,	// will convert Yes,No, On,Off to 1 and 0
//};
///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
//bool nlsf_get_FDF_tree_from_func_name(TreeNode &trFDF, LPCSTR lpcszFuncName, string& strCategory, DWORD dwCtrl = 0);
bool nlsf_get_FDF_tree_from_func_name(TreeNode &trFDF, LPCSTR lpcszFuncName, string& strCategory, DWORD dwCtrl = 0, bool bCustomized = true);
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
///End MOVE_NLSF_FUNC_FROM_NLFITSESSION
string  nlsf_get_param_init_code(const TreeNode &trFDF);
string  nlsf_get_formula(const TreeNode &trFDF);
string  nlsf_get_before_or_after_fitting_codes(const TreeNode &trFDF, bool bBeforeFitting);
string	nlsf_get_deriv_param_codes( const TreeNode& trFDF );///Sophy 10/20/2008 QA80-12406 ADD_DERIVATIVE_PARAM_PAGE_IN_CODE_TAB_OF_NLFIT_DLG
//void 	nlsf_update_show_FDF_filename(TreeNode & trFuncSel, string& strFDF);
void 	nlsf_update_show_func_description(TreeNode & trFuncSel, string& strDesc);	///Jasmine 01/27/07 SHOW_FUNC_DESCRIPTION_INSTEAD_OF_FDF_PATH
/// End MOVE_NLSF_FUNC_FROM_NLFITSESSION

///Cheney 2007-5-5 FUNC_DESCRIPTION_NOT_WORK
void 	nlsf_update_show_func_path(const TreeNode & trFuncSel, const string& strPath);
///end FUNC_DESCRIPTION_NOT_WORK

string  nlsf_get_constraints_codes(const TreeNode &trFDF);///Jasmine 05/08/06
///Joe 8/17/06 MOVE_NLSF_FUNC_FROM_NLFITSESSION
string	nlsf_get_formula(const TreeNode& tr, string strSubNode);
string 	nlsf_get_parainit(const TreeNode& tr);
string	nlsf_get_scripts(const TreeNode& tr);
TreeNode 	nlsf_get_parasetting(const TreeNode& tr);
TreeNode	nlsf_get_fittingpara(const TreeNode& tr, string strSubNode);

int		nlsf_get_fit_param_names(const TreeNode& trFDF, vector<string>& vstrParams);	///Jasmine 04/22/08 CENTRAILIZE_GET_NLSF_GET_PARAM_NAMES_CODES
///End MOVE_NLSF_FUNC_FROM_NLFITSESSION

///Cheney 2006-8-24 ADD_GLOBAL_FUNCTION_FOR_FINDXY
//lpcszFuncName[input]: fit funtion's name;  nParamsSize[input]: size of pParams list
//pParams[input]: fit funtion's params list array;  dX[input]: x value;  dY[output]: y value
bool compute_y_by_x(LPCSTR LpcszFuncFileName, int nParamsSize, double* pParams, double dX, double *pY);
///end ADD_GLOBAL_FUNCTION_FOR_FINDXY
/// ML 8/28/2006 MULTIPLE_DEPS_INDEPS_NLFIT
#ifdef		__NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
BOOL	nlsf_init_datarange(DataRange &dr, TreeNode& trInputData, IntArray *pvnWeightMethods = NULL, DoubleArray *pvrAs = NULL, DoubleArray *pvrBs = NULL, DoubleArray *pvrCs = NULL);
#endif		// __NLFIT_MULTI_DEPS_INDEPS_WEIGHTS__
/// end MULTIPLE_DEPS_INDEPS_NLFIT

/// Iris 11/16/06 ADD_PARAMETER_SETTING_TO_THEME
TreeNode	nlsf_check_get_GUI_params_with_ID(TreeNode& trGUI, int nNumParams = MAX_NUM_TOTAL_PARAMS);
///end ADD_PARAMETER_SETTING_TO_THEME

/// Cloud 03/24/07 MOVE_TO_DATA_H
/// Cloud 03/23/07 INIT_PARAMS_FOR_PEAK_FUNC
//void    nlsf_init_peak_params(Curve crvData, vector& vPos, vector& vWidth);
/// End INIT_PARAMS_FOR_PEAK_FUNC
/// End MOVE_TO_DATA_H

///Arvin/Cheney 03/26/07 QA70-9527 SUPPORT_SETTING_PARAMS_FROM_OC_LT
//Share, Fixed,... are bool vector
bool nlf_set_bool_param_from_user_params_setting(const TreeNode& trParams, vector<bool>& vParams, int nDataFrom);
//Vlaues, LowerBound,.. are double vector
bool nlf_set_double_param_from_user_params_setting(const TreeNode& trParams, vector& vParams, int nDataFrom);
//signdigits
bool nlf_set_int_param_from_user_params_setting(const TreeNode& trParams, vector<int>& vParams, int nDataFrom);///Jasmine 10/17/07 MISSING_SIGN_DIGITES
///end SUPPORT_SETTING_PARAMS_FROM_OC_LT

///Cheney 2007-4-14 IF_NO_THEME_AUTO_INIT_WILL_ACCORDING_TO_FDF
//read auto init params setting from FDF
bool nlf_is_auto_init_params(LPCSTR lpcszFuncName, bool& bAutoInit);
bool nlf_is_auto_init_params(const TreeNode& trFunc, bool& bAutoInit);
///end IF_NO_THEME_AUTO_INIT_WILL_ACCORDING_TO_FDF

///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
bool nlf_is_enable_linear_constraints(LPCSTR lpcszFuncName, bool& bConstraints);
bool nlf_is_enable_linear_constraints(const TreeNode& trFunc, bool& bConstraints);
///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS

///Cheney 2007-5-25 DO_SAVE_FDF
void nlf_delete_precompile_files(const string& strFunctionName);
///end DO_SAVE_FDF

///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
bool nlf_is_user_define_func(LPCSTR lpcszFuncName, bool& bUserDefine, string* pstrFuncType = NULL);
bool nlf_is_user_define_func(const TreeNode& trFunc, bool& bUserDefine, string* pstrFuncType = NULL);
///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
/// Hong 12/30/08 QA80-12878 v8.0992 FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION
bool nlf_is_built_in_func(const TreeNode& trFunc, bool& bBuiltIn, string* pstrFuncType = NULL);
bool nlf_is_built_in_null_func(const TreeNode& trFunc);
/// end FAST_POPUP_DLG_BY_SKIP_INIT_USING_NULL_FUNCTION

///Jasmine 06/08/07 NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION
#define STR_OLDFILENAME_ATTRIB			"OldName"	///Jasmine 06/13/07 MAKE_CONNECTION_BETWEEN_SAME_FUNCTION, from FunctionGroup
bool nlsf_load_FDF_to_tree(LPCSTR lpcszFDFname, TreeNode* pTreeNode, DWORD dwCtrl = 0, bool bCustomized = true);
/// Hong 07/25/08 QA80-11593 FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
//bool nlsf_save_to_customized_xml(TreeNode& trFunction);
/// end FIX_BUILD_IN_FDF_USER_ADDED_DERIVED_PARAMETERS_LOST_IN_FIT_REPORT
bool nlsf_remove_from_customized_xml(TreeNode& trFunction);
///End NEW_MECHANISM_TO_SAVE_BUILT_IN_FUNCTION

bool nlsf_load_fdf_tree(TreeNode &trFDF, LPCSTR lpcszFunc, LPCSTR lpcszCat = NULL);//------ CPY 4/3/08 PA_FIT_CNTRL_OPEN_EMPTY_NO_ERR_MSG

///Sophy 7/15/2010 ORG-545 CENTRALIZE_CODE_FOR_LOADING_FDF_TREE_FROM_FUNCTIONNAME
enum {
	FDFTYPE_NONE = -1,
	FDFTYPE_UNKNOWN,
	FDFTYPE_BUILTIN,
	FDFTYPE_USER,
};
int	nlsf_load_FDF_to_tree(TreeNode& trFunction, LPCSTR lpcszFuncName, string* pstrCategory = NULL);
///end CENTRALIZE_CODE_FOR_LOADING_FDF_TREE_FROM_FUNCTIONNAME
bool nlsf_update_residual_contour_levels(GraphLayer& gl, DataPlot& dp, vector& vData); ///Cheney 2007-8-21 QA70-10256-P7 ADD_GLOBAL_FUC_FOR_UPDATE_CONTOUR_LEVEL

string nlsf_get_source_page_name(const DataRange& dr, int nFitType, string *pstrLayerName = NULL); ///Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
string	nlsf_get_weight_method_name( int nMethodIndex ); ///Sophy 6/19/2008 QA80-10686 TREATE_DIFFERENT_WEIGHT_AS_DIFFERENT_INPUTDATA_ON_COMPARE_FIT_RESULT
//---------- CPY 3/39/08 SURFACE_FIT_USE_COLOR_CONTOUR_FOR_SRC_DATA
// moved to page_utils.h
/*
///Arvin 03/03/08 QA-11206 SETUP_CONTOUR_PLOT_FOR_SURFACE_FIT
bool nlsf_setup_source_data_contour(DataPlot& dp, vector* pz = NULL, int nSteps = 16);
bool nlsf_setup_fit_contour(DataPlot& dp, vector& zz, int nColor = SYSCOLOR_RED); 

// irl = Inner Residual Limit
// orl = Outer Residual Limit
// both expressed in percent of source data's Z range which is in zz[1] and zz[0]
bool nlsf_setup_residual_contour(DataPlot& dp, vector& zz, double irl = 20, double orl = 5, int nInnersteps = 8, int nOutSteps = 20); 
///end SETUP_CONTOUR_PLOT_FOR_SURFACE_FIT
*/
//--------- end SURFACE_FIT_USE_COLOR_CONTOUR_FOR_SRC_DATA

//------------------------------------------------------------------------------------
//----------Arvin 07/10/07 v8.0656 CLEAN_CODE_FOR_XF_SIMCURVE_AND_SIMSURFACE----------
//------------------------------------------------------------------------------------
#define IDST_SIMULATE_PARAS		(IDST_TREE_BRANCH_MASK + 1)

bool sim_xf_get_FDF(TreeNode &trGetN, TreeNode &trFF);
void sim_xf_get_param_list(vector& vParams, TreeNode& trParams);
int sim_xf_check_params_legality(LPCSTR lpcszFunName, LPCSTR lpcszCateg, const vector& vParamValues, string& strErrFuncOrParam, double& dLowerOrUpperBound);
bool sim_xf_check_tree_settings(TreeNode& trGetN, string& strErrMsg);
int sim_xf_update_grid_tree(TreeNode &trGetN, bool bInitGrid = false, bool bSimCurve = true, int* pCtrl = NULL);//bSimCurve, true is curve simulation, false is surface simulation 
bool sim_xf_on_save_button(TreeNode &trGetN, string& strErrMsg);
//------ Folger 02/12/08 IMPROVE_SIMULATE_CURVE
bool sim_xf_access_cate_and_func_last_used(string &strCategory, string &strFunction, bool bGet = true);
//------

//------ Folger 03/20/08 QA80-11155 CENTRALIZE_OUTPUT_PARAMETER_COMMENTS_FOR_SIMCURVE_AND_SIMSURFACE
void	sim_generate_function_and_parameters_comments(const DataRange &dr, LPCSTR lpcszFunction, const TreeNode &trParam);
//------

//------------------------------------------------------------------------------------
//----------end Arvin 07/10/07 v8.0656 CLEAN_CODE_FOR_XF_SIMCURVE_AND_SIMSURFACE------
//------------------------------------------------------------------------------------

//------Folger 07/11/07 ADD_LOAD_FUNCTION_NAME_FROM_CUSTOMIZE_XML
bool load_function_name_from_customize_xml(vector<string> &vsFuncName);
//------end ADD_LOAD_FUNCTION_NAME_FROM_CUSTOMIZE_XML

///Arvin 01/10/06 ADD_CREATING_CURVES_FUNCTIONS_FOR_PALETTE_EDIT_TOOL
enum{
	LINE_SEGMENT_CURVE,
	SPLINE_CURVE,
	GUASSAMP_CURVE,
	LOGISTIC_CURVE,
};

/**
	Remarks:
		Create user selected type curve defined by input points.
	Keywords:
	Example1:	
		void create_curve_for_palette_edit_ex1()
		{
			GraphLayer gl = Project.ActiveLayer();
			if (!gl)
			{
				return;
			}
			
			DataPlot dp = gl.DataPlots(0);		
			DataRange dr;
			vector vx, vy;
	        if(dp.GetDataRange(dr))
	        {
	        	DWORD dwPlotID;
	        	if(dr.GetData(DRR_GET_DEPENDENT | DRR_NO_FACTORS, 0, &dwPlotID, NULL, &vy, &vx) < 0)
	        	{
	        		printf("get_plot_data failed GetData");
	        		return;
	        	}
	        }
			vector vCurveX, vCurveY;
			int nPts = 30;
			int nCurveType = GUASSAMP_CURVE;
			if(!create_curve_for_palette_edit(vx, vy, vCurveX, vCurveY, nPts, nCurveType))
			{
				printf("create_curve_for_palette_edit failed");
				return;
			}
			
			WorksheetPage wksPage;
			wksPage.Create();
			Worksheet wksResult = wksPage.Layers(0);
			int nXCol, nYCol;
			nXCol = wksResult.AddCol("X Coordinate");
			nYCol = wksResult.AddCol("Y Coordinate");
			wksResult.Columns(nXCol).SetType(OKDATAOBJ_DESIGNATION_X);
			wksResult.Columns(nYCol).SetType(OKDATAOBJ_DESIGNATION_Y);
			DataRange drOut;
			drOut.Add("X", wksResult, 0, nXCol, -1, nXCol);
			drOut.Add("Y", wksResult, 0, nYCol, -1, nYCol);
			drOut.SetData(&vCurveY, &vCurveX);
			XYRange plotRange;
			plotRange.Add("X", wksResult, 0, nXCol, -1, nXCol);
			plotRange.Add("Y", wksResult, 0, nYCol, -1, nYCol);
			gl.AddPlot(plotRange, IDM_PLOT_LINE);
		}
	Parameters:
		vx = [input]
		vy = [input]
		vCurveX = [output]
		vCurveY = [output]
		nPts = [input]  
		nCurveType = [input]
	Return:
	SeeAlso: find_peaks_2nd_derivative
 */ 
bool create_curve_for_palette_edit(const vector& vx, const vector& vy, vector& vCurveX, vector& vCurveY, int nPts, int nCurveType = LINE_SEGMENT_CURVE);

bool nlsf_func_curve(const vector& vx, const vector& vy, const string strFuncName, vector& vCurveX, vector& vCurveY);

bool nlsf_logistic_curve(const vector& vx, const vector& vy, const int nPower, const int nCenter, vector& vCurveX, vector& vCurveY);
///end ADD_CREATING_CURVES_FUNCTIONS_FOR_PALETTE_EDIT_TOOL

///Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
#ifdef SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
bool nlsf_construct_parameter_branch_by_theme_Tree(const TreeNode& trTheme, TreeNode& trOp);
///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS

//------ Folger 04/11/08 APPLY_FDF_ORIGINAL_SETTING_AFTER_APPLY_THEME
//bool nlsf_apply_theme(LPCSTR lpcszClassName, TreeNode& trGUI, LPCSTR lpcszThemeName, bool bLoadFactDefault = true);
bool nlsf_apply_theme(LPCSTR lpcszClassName, TreeNode& trGUI, LPCSTR lpcszThemeName, bool bLoadFactDefault = true, LPCSTR lpcszFunctionName = NULL);
//------
bool apply_fdf(TreeNode& trGUI, LPCSTR lpcszFunctionName = NULL);

void nlsf_get_theme_filter_id_array(vector<int>& vnGUIID, vector<int>& vnThemeFilterID);
//bool nlsf_setup_theme_filter_setting(TreeNode& trGUI, const TreeNode& trThemeFilter, const vector<int>& vnGUIID, const vector<int>& vnThemeFilterID);
///---END QA80-11371 THEME_SAVING_OPTIONS
#endif

///end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION

///---Sim 04-10-2008 QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ
void nlsf_construct_theme_filter(TreeNode& trThemeFilter, bool bAddOther = true);
///---END QA80-11371 THEME_SAVING_OPTIONS_FOR_WIZ	

/// Hong 04/14/08 v8.0842 GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE
//#define		STR_BACKUP_ID_ATTRIB			"BackupID"
/// end GET_REAL_BOOK_SHEET_NAME_FROM_AUTO_TYPE

///Jasmine 04/14/08 SIM_ASK_CONVERT_PA_FIT_TREE_DATA_ID
/**$
	Remarks:
		convert DataID in operation tree to trGetN's corresponding tree node's DataID.
	Parameters:
		trGetN = [input] trGetN in pa_fit.oxf
		vnIDs = [input\output]the DataID to convert
	Return:
		-1 if fail, else return the size of vnIDs
*/
int pa_fit_convert_data_id_for_theme_saving(const TreeNode& trGetN, vector<int>& vnIDs);
///End SIM_ASK_CONVERT_PA_FIT_TREE_DATA_ID

/////////////////////////////////////////////////
////////////////////fit peaks////////////////////
/////////////////////////////////////////////////
#define STR_FUNC_PEAK_CENTER	"Peak Center"
#define STR_FUNC_PEAK_WIDTH		"Peak Width"
#define STR_FUNC_PEAK_CENTER2	"Peak Center 2"
#define STR_FUNC_PEAK_WIDTH2	"Peak Width 2"
#define STR_FUNC_PEAK_AMPLITUDE "Peak Amplitude"		///Kyle 11/05/2008 QA80-12509-P1 ADD_PEAK_AMPLITUDE_INTO_CONTROL_SESSION_OF_FO
//index is 1-offset
///------ Folger 06/18/09 CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES
//bool nlsf_get_peak_center_width_index(const TreeNode& trFDF, int* pnXCenter = NULL, int* pnXWidth = NULL);
//bool nlsf_get_2d_peak_center_width_index(const TreeNode& trFDF, int* pnXCenter = NULL, int* pnYCenter = NULL, int* pnXWidth = NULL, int* pnYWidth = NULL);
//bool nlsf_get_peak_center_width_index(LPCSTR lpcszFunction, LPCSTR lpcszCategory, int* pnXCenter = NULL, int* pnXWidth = NULL);
//bool nlsf_get_2d_peak_center_width_index(LPCSTR lpcszFunction, LPCSTR lpcszCategory, int* pnXCenter = NULL, int* pnYCenter = NULL, int* pnXWidth = NULL, int* pnYWidth = NULL);
bool nlsf_get_peak_param_indices(const TreeNode& trFDF, int* pnXCenter = NULL, int* pnXWidth = NULL, int* pnAmplitude = NULL);
bool nlsf_get_2d_peak_param_indices(const TreeNode& trFDF, int* pnXCenter = NULL, int* pnYCenter = NULL, int* pnXWidth = NULL, int* pnYWidth = NULL, int* pnAmplitude = NULL);
bool nlsf_get_peak_param_indices(LPCSTR lpcszFunction, LPCSTR lpcszCategory, int* pnXCenter = NULL, int* pnXWidth = NULL, int* pnAmplitude = NULL);
bool nlsf_get_2d_peak_param_indices(LPCSTR lpcszFunction, LPCSTR lpcszCategory, int* pnXCenter = NULL, int* pnYCenter = NULL, int* pnXWidth = NULL, int* pnYWidth = NULL, int* pnAmplitude = NULL);
///------ End CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES

///Jasmine 07/30/08 PEAK_FIT_CHECK_GOOD_PEAK_FUNC
int peak_fit_get_offset_param(LPCSTR lpcstrParams, bool b2DFunc);
///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
int peak_fit_get_center_param(LPCSTR lpcstrMeaning, bool bGetX);
int peak_fit_get_width_param(LPCSTR lpcstrMeaning, bool bGetX);
int peak_fit_get_height_param(LPCSTR lpcstrMeaning);
int peak_fit_get_center_param(const TreeNode& trFunction, bool bGetX);
int peak_fit_get_width_param(const TreeNode& trFunction, bool bGetX);
int peak_fit_get_height_param(const TreeNode& trFunction);
///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT

bool peak_fit_is_peak_func(const TreeNode& trFDF, vector<string>* pvsInvalidParams = NULL);
bool peak_fit_is_peak_func_ex(const TreeNode& trFuncGUI);
///End PEAK_FIT_CHECK_GOOD_PEAK_FUNC

///Jasmine 07/09/10 ORG-486 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
bool set_duplicate_unit_for_peak_fit(TreeNode& trFunction, bool bReset = false);

bool remove_peak_attributes_from_tree(TreeNode& trFunction);
bool write_peak_attributes_to_tree(const vector<string>& vsPeakAttrib, TreeNode& trFunction);
///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
/////////////////////////////////////////////////

bool nlsf_calc_ave_data(const vector& vConcatenateX, const vector& vConcatenateY, int& nAveSize, vector& vAveX, vector& vAveY, vector& vErr, int nErrType);

//------ Folger 07/29/08 QA80-11909 PA_FIT_SHOULD_PICK_UP_DEFAULT_PARAMETER_VALUES_IN_FDF_AND_CENTER_VALUES_FROM_FIND_PEAK
int		nlsf_get_params_init_info(const TreeNode& trFDF, vector& vParamValues, vector<string>* pvsParamNames = NULL);
//------

/**
	Parameters:
		trFDF = [input] FDF tree
		strCode = [output] parameter init code
	Return:
		return false if not ParametersInitialization.Script node in FDF tree or init code is empty, else return true.
*/
bool 	nlsf_get_param_init_code(const TreeNode& trFDF, string& strCode);

/// Iris 1/25/2010 PARETO_CHAR_ADD_LABEL_PLOT, moved to page_utils.h
/*
///Sophy 11/10/2008 CENTRALIZE_CODE_PEAK_LABEL_TYPE_FROM_NLFPREVIEW_AND_PAWIZCORE
enum{
	LABEL_X_VAL_GUI = 0,//the label text is going to come from x dataset,
	LABEL_Y_VAL_GUI = 1,//the label text is going to come from y dataset,
	LABEL_ROW_NUM_GUI = 2,//the label text is going to be the row number;
};
///end CENTRALIZE_CODE_PEAK_LABEL_TYPE_FROM_NLFPREVIEW_AND_PAWIZCORE
*/
///End PARETO_CHAR_ADD_LABEL_PLOT

/// Iris 11/11/2008 v8.0968 MOVE_PA_ENUM_TO_NEW_HEADER_PA_UTILS, moved from PFM_utils
string get_function_list(LPCSTR lpcszCategory);
///end MOVE_PA_ENUM_TO_NEW_HEADER_PA_UTILS

///Sophy 6/5/2009 MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION
///Arvin 03/12/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT as CP said
#define		STR_MIN_HEIGHT_GENERAL_LABEL		_L("Peak Min Height(%Y scale)")
#define 	STR_MIN_HEIGHT_SURFACE_LABEL		_L("Peak Min Height(%Z scale)")
///END REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
bool	add_auto_init_params_branch_under_replica(TreeNode& trReplicaInit);
///END MORE_SUPPORT_ON_NLFITSESSION_CUSTOMIZATION

///Kyle 11/04/2009 QA80-14584 SCV_ADD_FITTING_FUNCTIONS
#ifdef _ADD_FITTING_FUNCTIONS_TO_SCV
int nlsf_find_fitting_functions(vector<string>& vsFuncNames, vector<string>& vsFuncArgs, LPCSTR lpcszCategory);
#endif //_ADD_FITTING_FUNCTIONS_TO_SCV
///End SCV_ADD_FITTING_FUNCTIONS

/// Bill 07/12/2010 ORG-545 ADD_FUNCTION_TO_GET_FITFUNC_LIST_BY_FILE_TYPE
int nlsf_get_func_list(int nFileType, vector<string>& vsFuncNames, vector<string>& vsFileNames = NULL, vector<string>& vsCategorys = NULL);
/// End ADD_FUNCTION_TO_GET_FITFUNC_LIST_BY_FILE_TYPE

#endif _NLSF_UTILS_H
